/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import org.primefaces.application.resource.DynamicContentHandler;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.application.resource.PrimeResource;
import org.primefaces.application.resource.QRCodeHandler;
import org.primefaces.application.resource.StreamedContentHandler;
import org.primefaces.application.resource.barcode.BarcodeHandler;

public class PrimeResourceHandler
extends ResourceHandlerWrapper {
    private final Map<String, DynamicContentHandler> handlers;
    private final ResourceHandler wrapped;

    public PrimeResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
        this.handlers = new HashMap<String, DynamicContentHandler>();
        this.handlers.put(DynamicContentType.STREAMED_CONTENT.toString(), new StreamedContentHandler());
        if (this.isBarcodeHandlerAvailable()) {
            this.handlers.put(DynamicContentType.BARCODE.toString(), new BarcodeHandler());
        }
        if (this.isQRCodeHandlerAvailable()) {
            this.handlers.put(DynamicContentType.QR_CODE.toString(), new QRCodeHandler());
        }
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource resource = super.createResource(resourceName, libraryName);
        if (resource != null && libraryName != null && libraryName.equalsIgnoreCase("primefaces")) {
            return new PrimeResource(resource);
        }
        return resource;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String handlerType = (String)params.get("pfdrt");
        DynamicContentHandler handler = this.handlers.get(handlerType);
        if (handler != null) {
            handler.handle(context);
        } else {
            super.handleResourceRequest(context);
        }
    }

    private boolean isBarcodeHandlerAvailable() {
        try {
            Class.forName("org.krysalis.barcode4j.output.AbstractCanvasProvider");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private boolean isQRCodeHandlerAvailable() {
        try {
            Class.forName("net.glxn.qrgen.QRCode");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

