/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.calendar.converter.DatePatternConverter;
import org.primefaces.component.calendar.converter.PatternConverter;
import org.primefaces.component.calendar.converter.TimePatternConverter;

public class CalendarUtils {
    private static final List<PatternConverter> PATTERN_CONVERTERS = new ArrayList<PatternConverter>();

    public static String getValueAsString(FacesContext context, Calendar calendar) {
        Object submittedValue = calendar.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsString(context, (UIComponent)calendar, value);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendar.calculatePattern(), calendar.calculateLocale(context));
        dateFormat.setTimeZone(calendar.calculateTimeZone());
        return dateFormat.format(value);
    }

    public static String getValueAsString(FacesContext context, Calendar calendar, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(calendar.calculatePattern(), calendar.calculateLocale(context));
            dateFormat.setTimeZone(calendar.calculateTimeZone());
            return dateFormat.format((Date)value);
        }
        throw new FacesException("Value could be either String or java.util.Date");
    }

    public static String getTimeOnlyValueAsString(FacesContext context, Calendar calendar) {
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(calendar.calculateTimeOnlyPattern(), calendar.calculateLocale(context));
            format.setTimeZone(calendar.calculateTimeZone());
            return format.format(calendar.getValue());
        }
        throw new FacesException("Value could be either String or java.util.Date");
    }

    public static String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        String convertedPattern = pattern;
        for (PatternConverter converter : PATTERN_CONVERTERS) {
            convertedPattern = converter.convert(convertedPattern);
        }
        return convertedPattern;
    }

    static {
        PATTERN_CONVERTERS.add(new TimePatternConverter());
        PATTERN_CONVERTERS.add(new DatePatternConverter());
    }
}

