/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import org.primefaces.context.RequestContext;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimePartialResponseWriter
extends PartialResponseWriter {
    private static final Map<String, String> CALLBACK_EXTENSION_PARAMS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("ln", "primefaces");
            this.put("type", "args");
        }
    });
    private PartialResponseWriter wrapped;

    public PrimePartialResponseWriter(PartialResponseWriter writer) {
        super((ResponseWriter)writer);
        this.wrapped = writer;
    }

    private void encodeCallbackParams(Map<String, Object> params) throws IOException, JSONException {
        if (params != null && !params.isEmpty()) {
            this.startExtension(CALLBACK_EXTENSION_PARAMS);
            this.write("{");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String json;
                String paramName = it.next();
                Object paramValue = params.get(paramName);
                if (paramValue instanceof JSONObject) {
                    json = ((JSONObject)paramValue).toString();
                    this.write("\"");
                    this.write(paramName);
                    this.write("\":{");
                    this.write(json.substring(1, json.length() - 1));
                    this.write("}");
                } else if (paramValue instanceof JSONArray) {
                    json = ((JSONArray)paramValue).toString();
                    this.write("\"");
                    this.write(paramName);
                    this.write("\":[");
                    this.write(json.substring(1, json.length() - 1));
                    this.write("]");
                } else if (this.isBean(paramValue)) {
                    this.write("\"");
                    this.write(paramName);
                    this.write("\":");
                    this.write(new JSONObject(paramValue).toString());
                } else {
                    json = new JSONObject().put(paramName, paramValue).toString();
                    this.write(json.substring(1, json.length() - 1));
                }
                if (!it.hasNext()) continue;
                this.write(",");
            }
            this.write("}");
            this.endExtension();
        }
    }

    private void encodeScripts(RequestContext requestContext) throws IOException {
        List<String> scripts = requestContext.getScriptsToExecute();
        if (!scripts.isEmpty()) {
            this.startEval();
            for (int i = 0; i < scripts.size(); ++i) {
                this.write(scripts.get(i));
                this.write(59);
            }
            this.endEval();
        }
    }

    public void delete(String targetId) throws IOException {
        this.wrapped.delete(targetId);
    }

    public void endError() throws IOException {
        this.wrapped.endError();
    }

    public void endEval() throws IOException {
        this.wrapped.endEval();
    }

    public void endExtension() throws IOException {
        this.wrapped.endExtension();
    }

    public void endInsert() throws IOException {
        this.wrapped.endInsert();
    }

    public void endUpdate() throws IOException {
        this.wrapped.endUpdate();
    }

    public void redirect(String url) throws IOException {
        this.wrapped.redirect(url);
    }

    public void startDocument() throws IOException {
        this.wrapped.startDocument();
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext != null) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                if (context.getViewRoot() instanceof NamingContainer) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("parameterNamespace", context.getViewRoot().getContainerClientId(context));
                    this.encodeCallbackParams(params);
                }
            }
            catch (Exception exception) {
                throw new AbortProcessingException((Throwable)exception);
            }
        }
    }

    public void endDocument() throws IOException {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext != null) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                if (context.isValidationFailed()) {
                    requestContext.addCallbackParam("validationFailed", true);
                }
                this.encodeCallbackParams(requestContext.getCallbackParams());
                this.encodeScripts(requestContext);
            }
            catch (Exception exception) {
                throw new AbortProcessingException((Throwable)exception);
            }
        }
        this.wrapped.endDocument();
    }

    public void startError(String errorName) throws IOException {
        this.wrapped.startError(errorName);
    }

    public void startEval() throws IOException {
        this.wrapped.startEval();
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.wrapped.startExtension(attributes);
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.wrapped.startInsertAfter(targetId);
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.wrapped.startInsertBefore(targetId);
    }

    public void startUpdate(String targetId) throws IOException {
        this.wrapped.startUpdate(targetId);
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.wrapped.updateAttributes(targetId, attributes);
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }
}

