/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.RequestContext;

public class HeadRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent middle;
        String theme;
        String themeParamValue;
        ResponseWriter writer = context.getResponseWriter();
        ConfigContainer cc = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        ProjectStage projectStage = context.getApplication().getProjectStage();
        boolean csvEnabled = cc.isClientSideValidationEnabled();
        writer.startElement("head", component);
        UIComponent first = component.getFacet("first");
        if (first != null) {
            first.encodeAll(context);
        }
        if ((themeParamValue = RequestContext.getCurrentInstance().getApplicationContext().getConfig().getTheme()) != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "aristo";
        }
        if (theme != null && !theme.equals("none")) {
            this.encodeCSS(context, "primefaces-" + theme, "theme.css");
        }
        if (cc.isFontAwesomeEnabled()) {
            this.encodeCSS(context, "primefaces", "fa/font-awesome.css");
        }
        if ((middle = component.getFacet("middle")) != null) {
            middle.encodeAll(context);
        }
        UIViewRoot viewRoot = context.getViewRoot();
        for (UIComponent resource : viewRoot.getComponentResources(context, "head")) {
            resource.encodeAll(context);
        }
        if (csvEnabled) {
            this.encodeValidationResources(context, cc.isBeanValidationAvailable());
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("if(window.PrimeFaces){");
        if (csvEnabled) {
            writer.write("PrimeFaces.settings.locale='" + context.getViewRoot().getLocale() + "';");
            writer.write("PrimeFaces.settings.validateEmptyFields=" + cc.isValidateEmptyFields() + ";");
            writer.write("PrimeFaces.settings.considerEmptyStringNull=" + cc.isInterpretEmptyStringAsNull() + ";");
        }
        if (cc.isLegacyWidgetNamespace()) {
            writer.write("PrimeFaces.settings.legacyWidgetNamespace=true;");
        }
        if (!projectStage.equals((Object)ProjectStage.Production)) {
            writer.write("PrimeFaces.settings.projectStage='" + projectStage.toString() + "';");
        }
        writer.write("}");
        writer.endElement("script");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent last = component.getFacet("last");
        if (last != null) {
            last.encodeAll(context);
        }
        writer.endElement("head");
    }

    protected void encodeCSS(FacesContext context, String library, String resource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resource cssResource = context.getApplication().getResourceHandler().createResource(resource, library);
        if (cssResource == null) {
            throw new FacesException("Error loading css, cannot find \"" + resource + "\" resource of \"" + library + "\" library");
        }
        writer.startElement("link", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)cssResource.getRequestPath(), null);
        writer.endElement("link");
    }

    protected void encodeValidationResources(FacesContext context, boolean beanValidationEnabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resource resource = context.getApplication().getResourceHandler().createResource("validation/validation.js", "primefaces");
        if (resource != null) {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
        if (beanValidationEnabled && (resource = context.getApplication().getResourceHandler().createResource("validation/beanvalidation.js", "primefaces")) != null) {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
    }
}

