/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.exceptionhandler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseId;
import javax.faces.view.ViewDeclarationLanguage;
import org.primefaces.application.exceptionhandler.ExceptionInfo;
import org.primefaces.component.ajaxexceptionhandler.AjaxExceptionHandler;
import org.primefaces.component.ajaxexceptionhandler.AjaxExceptionHandlerVisitCallback;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;

public class PrimeExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger LOG = Logger.getLogger(PrimeExceptionHandler.class.getName());
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final ExceptionHandler wrapped;

    public PrimeExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getResponseComplete()) {
            return;
        }
        Iterable exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents();
        if (exceptionQueuedEvents != null && exceptionQueuedEvents.iterator() != null) {
            Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
            if (unhandledExceptionQueuedEvents.hasNext()) {
                try {
                    Throwable throwable = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
                    unhandledExceptionQueuedEvents.remove();
                    Throwable rootCause = this.getRootCause(throwable);
                    ExceptionInfo info = this.createExceptionInfo(rootCause);
                    if (context.getApplication().getProjectStage() == ProjectStage.Development) {
                        rootCause.printStackTrace();
                    }
                    if (this.isLogException(context, rootCause)) {
                        LOG.log(Level.SEVERE, rootCause.getMessage(), rootCause);
                    }
                    if (context.getPartialViewContext().isAjaxRequest()) {
                        this.handleAjaxException(context, rootCause, info);
                    } else {
                        this.handleRedirect(context, rootCause, info, false);
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Could not handle exception!", ex);
                }
            }
            while (unhandledExceptionQueuedEvents.hasNext()) {
                unhandledExceptionQueuedEvents.next();
                unhandledExceptionQueuedEvents.remove();
            }
        }
    }

    protected boolean isLogException(FacesContext context, Throwable rootCause) {
        return !context.isProjectStage(ProjectStage.Production) || rootCause == null || !(rootCause instanceof ViewExpiredException);
    }

    public Throwable getRootCause(Throwable throwable) {
        while ((ELException.class.isInstance(throwable) || FacesException.class.isInstance(throwable)) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    protected void handleAjaxException(FacesContext context, Throwable rootCause, ExceptionInfo info) throws Exception {
        ExternalContext externalContext = context.getExternalContext();
        boolean responseResetted = false;
        if (context.getCurrentPhaseId().equals(PhaseId.RENDER_RESPONSE) && !externalContext.isResponseCommitted()) {
            String characterEncoding = externalContext.getResponseCharacterEncoding();
            externalContext.responseReset();
            externalContext.setResponseCharacterEncoding(characterEncoding);
            responseResetted = true;
        }
        rootCause = this.buildView(context, rootCause, rootCause);
        AjaxExceptionHandler handlerComponent = this.findHandlerComponent(context, rootCause);
        context.getAttributes().put(ExceptionInfo.ATTRIBUTE_NAME, info);
        if (handlerComponent == null) {
            this.handleRedirect(context, rootCause, info, responseResetted);
        } else {
            List<UIComponent> updates;
            externalContext.addResponseHeader("Content-Type", "text/xml; charset=" + externalContext.getResponseCharacterEncoding());
            externalContext.addResponseHeader("Cache-Control", "no-cache");
            externalContext.setResponseContentType("text/xml");
            PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
            writer.startDocument();
            writer.startElement("changes", null);
            if (!ComponentUtils.isValueBlank(handlerComponent.getUpdate()) && (updates = SearchExpressionFacade.resolveComponents(context, (UIComponent)handlerComponent, handlerComponent.getUpdate())) != null && updates.size() > 0) {
                context.setResponseWriter((ResponseWriter)writer);
                for (int i = 0; i < updates.size(); ++i) {
                    UIComponent component = updates.get(i);
                    writer.startElement("update", null);
                    writer.writeAttribute("id", (Object)component.getClientId(context), null);
                    writer.startCDATA();
                    component.encodeAll(context);
                    writer.endCDATA();
                    writer.endElement("update");
                }
            }
            if (!ComponentUtils.isValueBlank(handlerComponent.getOnexception())) {
                writer.startElement("eval", null);
                writer.startCDATA();
                writer.write("var hf=function(type,message,timestampp){");
                writer.write(handlerComponent.getOnexception());
                writer.write("};hf.call(this,\"" + info.getType() + "\",\"" + ComponentUtils.escapeText(info.getMessage()) + "\",\"" + info.getFormattedTimestamp() + "\");");
                writer.endCDATA();
                writer.endElement("eval");
            }
            writer.endElement("changes");
            writer.endDocument();
            context.responseComplete();
        }
    }

    protected ExceptionInfo createExceptionInfo(Throwable rootCause) throws IOException {
        ExceptionInfo info = new ExceptionInfo();
        info.setException(rootCause);
        info.setMessage(rootCause.getMessage());
        info.setStackTrace(rootCause.getStackTrace());
        info.setTimestamp(new Date());
        info.setType(rootCause.getClass().getName());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        rootCause.printStackTrace(pw);
        info.setFormattedStackTrace(sw.toString().replaceAll("(\r\n|\n)", "<br/>"));
        pw.close();
        sw.close();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        info.setFormattedTimestamp(format.format(info.getTimestamp()));
        return info;
    }

    protected AjaxExceptionHandler findHandlerComponent(FacesContext context, Throwable throwable) {
        AjaxExceptionHandlerVisitCallback visitCallback = new AjaxExceptionHandlerVisitCallback(throwable);
        context.getViewRoot().visitTree(VisitContext.createVisitContext((FacesContext)context), (VisitCallback)visitCallback);
        return visitCallback.getHandler();
    }

    protected Throwable buildView(FacesContext context, Throwable throwable, Throwable rootCause) throws IOException {
        if (context.getViewRoot() == null) {
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            String viewId = viewHandler.deriveViewId(context, this.calculateViewId(context));
            ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
            UIViewRoot viewRoot = vdl.createView(context, viewId);
            context.setViewRoot(viewRoot);
            vdl.buildView(context, viewRoot);
            if (rootCause == null && throwable instanceof IllegalArgumentException) {
                rootCause = new ViewExpiredException(viewId);
            }
        }
        return rootCause;
    }

    protected String calculateViewId(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    protected void handleRedirect(FacesContext context, Throwable rootCause, ExceptionInfo info, boolean responseResetted) throws IOException {
        context.getExternalContext().getSessionMap().put(ExceptionInfo.ATTRIBUTE_NAME, info);
        Map<String, String> errorPages = RequestContext.getCurrentInstance().getApplicationContext().getConfig().getErrorPages();
        String errorPage = errorPages.get(rootCause.getClass().getName());
        if (errorPage == null) {
            errorPage = errorPages.get(null);
        }
        if (errorPage == null) {
            throw new IllegalArgumentException("No default error page (Status 500 or java.lang.Throwable) and no error page for type \"" + rootCause.getClass() + "\" defined!");
        }
        String url = context.getExternalContext().getRequestContextPath() + errorPage;
        if (responseResetted && context.getPartialViewContext().isAjaxRequest()) {
            ExternalContext externalContext = context.getExternalContext();
            PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
            externalContext.addResponseHeader("Content-Type", "text/xml; charset=" + externalContext.getResponseCharacterEncoding());
            externalContext.addResponseHeader("Cache-Control", "no-cache");
            externalContext.setResponseContentType("text/xml");
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            writer.startElement("partial-response", null);
            writer.startElement("redirect", null);
            writer.writeAttribute("url", (Object)url, null);
            writer.endElement("redirect");
            writer.endElement("partial-response");
        } else {
            context.getExternalContext().redirect(url);
        }
        context.responseComplete();
    }
}

