/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.MixedClientBehaviorHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.event.DateViewChangeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class Calendar
extends HtmlInputText
implements Widget,
InputHolder,
MixedClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Calendar";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.CalendarRenderer";
    public static final String INPUT_STYLE_CLASS = "ui-inputfield ui-widget ui-state-default ui-corner-all";
    public static final String MOBILE_POPUP_CONTAINER_CLASS = "ui-calendar ui-calendar-popup";
    public static final String MOBILE_INLINE_CONTAINER_CLASS = "ui-calendar ui-calendar-inline";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("blur", "change", "valueChange", "click", "dblclick", "focus", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "select", "dateSelect", "viewChange"));
    private Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();
    private Locale calculatedLocale;
    private TimeZone appropriateTimeZone;
    private String timeOnlyPattern = null;
    private boolean conversionFailed = false;

    public Calendar() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getPlaceholder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.placeholder), null);
    }

    public void setPlaceholder(String _placeholder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.placeholder), (Object)_placeholder);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public Object getMindate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mindate), null);
    }

    public void setMindate(Object _mindate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mindate), _mindate);
    }

    public Object getMaxdate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxdate), null);
    }

    public void setMaxdate(Object _maxdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxdate), _maxdate);
    }

    public int getPages() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pages), (Object)1);
    }

    public void setPages(int _pages) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pages), (Object)_pages);
    }

    public String getMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mode), (Object)"popup");
    }

    public void setMode(String _mode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mode), (Object)_mode);
    }

    public String getPattern() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pattern), null);
    }

    public void setPattern(String _pattern) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pattern), (Object)_pattern);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object _locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), _locale);
    }

    public boolean isNavigator() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.navigator), (Object)false);
    }

    public void setNavigator(boolean _navigator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.navigator), (Object)_navigator);
    }

    public Object getTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeZone), null);
    }

    public void setTimeZone(Object _timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeZone), _timeZone);
    }

    public boolean isReadonlyInput() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyInput), (Object)false);
    }

    public void setReadonlyInput(boolean _readonlyInput) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyInput), (Object)_readonlyInput);
    }

    public boolean isShowButtonPanel() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showButtonPanel), (Object)false);
    }

    public void setShowButtonPanel(boolean _showButtonPanel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showButtonPanel), (Object)_showButtonPanel);
    }

    public String getEffect() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.effect), null);
    }

    public void setEffect(String _effect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.effect), (Object)_effect);
    }

    public String getEffectDuration() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.effectDuration), (Object)"normal");
    }

    public void setEffectDuration(String _effectDuration) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.effectDuration), (Object)_effectDuration);
    }

    public String getShowOn() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOn), (Object)"focus");
    }

    public void setShowOn(String _showOn) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOn), (Object)_showOn);
    }

    public boolean isShowWeek() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showWeek), (Object)false);
    }

    public void setShowWeek(boolean _showWeek) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showWeek), (Object)_showWeek);
    }

    public boolean isDisabledWeekends() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabledWeekends), (Object)false);
    }

    public void setDisabledWeekends(boolean _disabledWeekends) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabledWeekends), (Object)_disabledWeekends);
    }

    public boolean isShowOtherMonths() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showOtherMonths), (Object)false);
    }

    public void setShowOtherMonths(boolean _showOtherMonths) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showOtherMonths), (Object)_showOtherMonths);
    }

    public boolean isSelectOtherMonths() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectOtherMonths), (Object)false);
    }

    public void setSelectOtherMonths(boolean _selectOtherMonths) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectOtherMonths), (Object)_selectOtherMonths);
    }

    public String getYearRange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.yearRange), null);
    }

    public void setYearRange(String _yearRange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.yearRange), (Object)_yearRange);
    }

    public boolean isTimeOnly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeOnly), (Object)false);
    }

    public void setTimeOnly(boolean _timeOnly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeOnly), (Object)_timeOnly);
    }

    public int getStepHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepHour), (Object)1);
    }

    public void setStepHour(int _stepHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepHour), (Object)_stepHour);
    }

    public int getStepMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepMinute), (Object)1);
    }

    public void setStepMinute(int _stepMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepMinute), (Object)_stepMinute);
    }

    public int getStepSecond() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stepSecond), (Object)1);
    }

    public void setStepSecond(int _stepSecond) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stepSecond), (Object)_stepSecond);
    }

    public int getMinHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHour), (Object)0);
    }

    public void setMinHour(int _minHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minHour), (Object)_minHour);
    }

    public int getMaxHour() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxHour), (Object)23);
    }

    public void setMaxHour(int _maxHour) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxHour), (Object)_maxHour);
    }

    public int getMinMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minMinute), (Object)0);
    }

    public void setMinMinute(int _minMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minMinute), (Object)_minMinute);
    }

    public int getMaxMinute() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxMinute), (Object)59);
    }

    public void setMaxMinute(int _maxMinute) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxMinute), (Object)_maxMinute);
    }

    public int getMinSecond() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minSecond), (Object)0);
    }

    public void setMinSecond(int _minSecond) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minSecond), (Object)_minSecond);
    }

    public int getMaxSecond() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxSecond), (Object)59);
    }

    public void setMaxSecond(int _maxSecond) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxSecond), (Object)_maxSecond);
    }

    public Object getPagedate() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pagedate), null);
    }

    public void setPagedate(Object _pagedate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pagedate), _pagedate);
    }

    public String getBeforeShowDay() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.beforeShowDay), null);
    }

    public void setBeforeShowDay(String _beforeShowDay) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.beforeShowDay), (Object)_beforeShowDay);
    }

    public String getMask() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mask), (Object)"false");
    }

    public void setMask(String _mask) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.mask), (Object)_mask);
    }

    public String getTimeControlType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeControlType), null);
    }

    public void setTimeControlType(String _timeControlType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeControlType), (Object)_timeControlType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locale calculateLocale(FacesContext facesContext) {
        if (this.calculatedLocale != null) return this.calculatedLocale;
        Object userLocale = this.getLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                this.calculatedLocale = ComponentUtils.toLocale((String)userLocale);
                return this.calculatedLocale;
            } else {
                if (!(userLocale instanceof Locale)) throw new IllegalArgumentException("Type:" + userLocale.getClass() + " is not a valid locale type for calendar:" + this.getClientId(facesContext));
                this.calculatedLocale = (Locale)userLocale;
            }
            return this.calculatedLocale;
        } else {
            this.calculatedLocale = facesContext.getViewRoot().getLocale();
        }
        return this.calculatedLocale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeZone calculateTimeZone() {
        if (this.appropriateTimeZone != null) return this.appropriateTimeZone;
        Object usertimeZone = this.getTimeZone();
        if (usertimeZone != null) {
            if (usertimeZone instanceof String) {
                this.appropriateTimeZone = TimeZone.getTimeZone((String)usertimeZone);
                return this.appropriateTimeZone;
            } else {
                if (!(usertimeZone instanceof TimeZone)) throw new IllegalArgumentException("TimeZone could be either String or java.util.TimeZone");
                this.appropriateTimeZone = (TimeZone)usertimeZone;
            }
            return this.appropriateTimeZone;
        } else {
            this.appropriateTimeZone = TimeZone.getDefault();
        }
        return this.appropriateTimeZone;
    }

    public boolean isPopup() {
        return this.getMode().equalsIgnoreCase("popup");
    }

    public boolean hasTime() {
        String pattern = this.getPattern();
        return pattern != null && pattern.indexOf(":") != -1;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public Collection<String> getUnobstrusiveEventNames() {
        return Collections.unmodifiableCollection(Arrays.asList("dateSelect", "viewChange"));
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName != null) {
                if (eventName.equals("dateSelect")) {
                    this.customEvents.put("dateSelect", (AjaxBehaviorEvent)event);
                } else if (eventName.equals("viewChange")) {
                    int month = Integer.parseInt((String)params.get(clientId + "_month"));
                    int year = Integer.parseInt((String)params.get(clientId + "_year"));
                    DateViewChangeEvent dateViewChangeEvent = new DateViewChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), month, year);
                    dateViewChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)dateViewChangeEvent);
                } else {
                    super.queueEvent(event);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid() && this.isRequestSource(context)) {
            Iterator<String> customEventIter = this.customEvents.keySet().iterator();
            while (customEventIter.hasNext()) {
                AjaxBehaviorEvent behaviorEvent = this.customEvents.get(customEventIter.next());
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getValue());
                if (behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    selectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent((FacesEvent)selectEvent);
            }
        }
    }

    public String calculatePattern() {
        String pattern = this.getPattern();
        Locale locale = this.calculateLocale(this.getFacesContext());
        return pattern == null ? ((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern() : pattern;
    }

    public String calculateTimeOnlyPattern() {
        if (this.timeOnlyPattern == null) {
            String localePattern = ((SimpleDateFormat)DateFormat.getDateInstance(3, this.calculateLocale(this.getFacesContext()))).toPattern();
            String userTimePattern = this.getPattern();
            this.timeOnlyPattern = localePattern + " " + userTimePattern;
        }
        return this.timeOnlyPattern;
    }

    public void setConversionFailed(boolean value) {
        this.conversionFailed = value;
    }

    public boolean isConversionFailed() {
        return this.conversionFailed;
    }

    @Override
    public String getInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    @Override
    public String getValidatableInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        placeholder,
        widgetVar,
        mindate,
        maxdate,
        pages,
        mode,
        pattern,
        locale,
        navigator,
        timeZone,
        readonlyInput,
        showButtonPanel,
        effect,
        effectDuration,
        showOn,
        showWeek,
        disabledWeekends,
        showOtherMonths,
        selectOtherMonths,
        yearRange,
        timeOnly,
        stepHour,
        stepMinute,
        stepSecond,
        minHour,
        maxHour,
        minMinute,
        maxMinute,
        minSecond,
        maxSecond,
        pagedate,
        beforeShowDay,
        mask,
        timeControlType;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

