/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.messages.Messages;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.IteratorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Iterator messages;
        Messages uiMessages = (Messages)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uiMessages.getClientId(context);
        HashMap<String, List<FacesMessage>> messagesMap = new HashMap<String, List<FacesMessage>>();
        boolean globalOnly = uiMessages.isGlobalOnly();
        String containerClass = uiMessages.isShowIcon() ? "ui-messages ui-widget" : "ui-messages ui-messages-noicon ui-widget";
        String style = uiMessages.getStyle();
        String styleClass = uiMessages.getStyleClass();
        styleClass = styleClass == null ? containerClass : containerClass + " " + styleClass;
        String _for = uiMessages.getFor();
        if (_for != null) {
            Iterator temp;
            messages = context.getMessages(_for);
            UIComponent forComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)uiMessages, _for, 2);
            if (forComponent != null && (temp = context.getMessages(forComponent.getClientId(context))) != null && temp.hasNext()) {
                messages = new IteratorChain(messages, temp);
            }
        } else {
            Iterator iterator = messages = uiMessages.isGlobalOnly() ? context.getMessages(null) : context.getMessages();
        }
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            Object severity = message.getSeverity();
            if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                this.addMessage(uiMessages, message, messagesMap, "info");
                continue;
            }
            if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                this.addMessage(uiMessages, message, messagesMap, "warn");
                continue;
            }
            if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                this.addMessage(uiMessages, message, messagesMap, "error");
                continue;
            }
            if (!severity.equals(FacesMessage.SEVERITY_FATAL)) continue;
            this.addMessage(uiMessages, message, messagesMap, "fatal");
        }
        writer.startElement("div", (UIComponent)uiMessages);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("aria-live", (Object)"polite", null);
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("data-global", (Object)String.valueOf(globalOnly), null);
            writer.writeAttribute("data-summary", (Object)uiMessages.isShowSummary(), null);
            writer.writeAttribute("data-detail", (Object)uiMessages.isShowDetail(), null);
            writer.writeAttribute("data-severity", (Object)this.getClientSideSeverity(uiMessages.getSeverity()), null);
            writer.writeAttribute("data-redisplay", (Object)String.valueOf(uiMessages.isRedisplay()), null);
        }
        for (Object severity : messagesMap.keySet()) {
            List severityMessages = (List)messagesMap.get(severity);
            if (severityMessages.size() <= 0) continue;
            this.encodeSeverityMessages(context, uiMessages, (String)severity, severityMessages);
        }
        writer.endElement("div");
    }

    protected void addMessage(Messages uiMessages, FacesMessage message, Map<String, List<FacesMessage>> messagesMap, String severity) {
        if (this.shouldRender(uiMessages, message, severity)) {
            List<FacesMessage> severityMessages = messagesMap.get(severity);
            if (severityMessages == null) {
                severityMessages = new ArrayList<FacesMessage>();
                messagesMap.put(severity, severityMessages);
            }
            severityMessages.add(message);
        }
    }

    protected void encodeSeverityMessages(FacesContext context, Messages uiMessages, String severity, List<FacesMessage> messages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClassPrefix = "ui-messages-" + severity;
        boolean escape = uiMessages.isEscape();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)(styleClassPrefix + " ui-corner-all"), null);
        if (uiMessages.isClosable()) {
            this.encodeCloseIcon(context, uiMessages);
        }
        if (uiMessages.isShowIcon()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-icon"), null);
            writer.endElement("span");
        }
        writer.startElement("ul", null);
        for (FacesMessage msg : messages) {
            String detail;
            writer.startElement("li", null);
            String summary = msg.getSummary() != null ? msg.getSummary() : "";
            String string = detail = msg.getDetail() != null ? msg.getDetail() : summary;
            if (uiMessages.isShowSummary()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(styleClassPrefix + "-summary"), null);
                if (escape) {
                    writer.writeText((Object)summary, null);
                } else {
                    writer.write(summary);
                }
                writer.endElement("span");
            }
            if (uiMessages.isShowDetail()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(styleClassPrefix + "-detail"), null);
                if (escape) {
                    writer.writeText((Object)detail, null);
                } else {
                    writer.write(detail);
                }
                writer.endElement("span");
            }
            writer.endElement("li");
            msg.rendered();
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeCloseIcon(FacesContext context, Messages uiMessages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-messages-close", null);
        writer.writeAttribute("onclick", (Object)"$(this).parent().slideUp();return false;", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
        writer.endElement("span");
        writer.endElement("a");
    }
}

