/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.validate.bean;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.context.RequestContext;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.validate.bean.AssertFalseClientValidationConstraint;
import org.primefaces.validate.bean.AssertTrueClientValidationConstraint;
import org.primefaces.validate.bean.BeanValidationMetadata;
import org.primefaces.validate.bean.ClientConstraint;
import org.primefaces.validate.bean.ClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMaxClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMinClientValidationConstraint;
import org.primefaces.validate.bean.DigitsClientValidationConstraint;
import org.primefaces.validate.bean.FutureClientValidationConstraint;
import org.primefaces.validate.bean.MaxClientValidationConstraint;
import org.primefaces.validate.bean.MinClientValidationConstraint;
import org.primefaces.validate.bean.NotNullClientValidationConstraint;
import org.primefaces.validate.bean.NullClientValidationConstraint;
import org.primefaces.validate.bean.PastClientValidationConstraint;
import org.primefaces.validate.bean.PatternClientValidationConstraint;
import org.primefaces.validate.bean.SizeClientValidationConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationMetadataMapper {
    private static final Logger LOG = Logger.getLogger(BeanValidationMetadataMapper.class.getName());
    private static final Map<Class<? extends Annotation>, ClientValidationConstraint> CONSTRAINT_MAPPING = new HashMap<Class<? extends Annotation>, ClientValidationConstraint>();

    public static BeanValidationMetadata resolveValidationMetadata(FacesContext context, UIComponent component, RequestContext requestContext) throws IOException {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        ArrayList<String> validatorIds = new ArrayList<String>();
        try {
            Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractAllConstraintDescriptors(context, requestContext, component.getValueExpression("value"));
            if (constraints != null && !constraints.isEmpty()) {
                for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                    Class<?> resolvedBy;
                    Class<? extends Annotation> annotationType = constraintDescriptor.getAnnotation().annotationType();
                    ClientValidationConstraint clientValidationConstraint = CONSTRAINT_MAPPING.get(annotationType);
                    if (clientValidationConstraint != null) {
                        String validatorId = clientValidationConstraint.getValidatorId();
                        Map<String, Object> constraintMetadata = clientValidationConstraint.getMetadata(constraintDescriptor);
                        if (constraintMetadata != null) {
                            metadata.putAll(constraintMetadata);
                        }
                        if (validatorId == null) continue;
                        validatorIds.add(validatorId);
                        continue;
                    }
                    ClientConstraint clientConstraint = annotationType.getAnnotation(ClientConstraint.class);
                    if (clientConstraint == null || (resolvedBy = clientConstraint.resolvedBy()) == null) continue;
                    try {
                        ClientValidationConstraint customClientValidationConstraint = (ClientValidationConstraint)resolvedBy.newInstance();
                        String validatorId = customClientValidationConstraint.getValidatorId();
                        Map<String, Object> constraintMetadata = customClientValidationConstraint.getMetadata(constraintDescriptor);
                        if (constraintMetadata != null) {
                            metadata.putAll(constraintMetadata);
                        }
                        if (validatorId == null) continue;
                        validatorIds.add(validatorId);
                    }
                    catch (InstantiationException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip resolving of CSV BV metadata for component \"" + component.getClientId(context) + "\" because" + " the ValueExpression of the \"value\" attribute" + " isn't resolvable completely (e.g. a sub-expression returns null)";
            LOG.log(Level.FINE, message);
        }
        return new BeanValidationMetadata(metadata, validatorIds);
    }

    public static void registerConstraintMapping(Class<? extends Annotation> constraint, ClientValidationConstraint clientValidationConstraint) {
        CONSTRAINT_MAPPING.put(constraint, clientValidationConstraint);
    }

    public static ClientValidationConstraint removeConstraintMapping(Class<? extends Annotation> constraint) {
        return CONSTRAINT_MAPPING.remove(constraint);
    }

    static {
        CONSTRAINT_MAPPING.put(NotNull.class, new NotNullClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Null.class, new NullClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Size.class, new SizeClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Min.class, new MinClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Max.class, new MaxClientValidationConstraint());
        CONSTRAINT_MAPPING.put(DecimalMin.class, new DecimalMinClientValidationConstraint());
        CONSTRAINT_MAPPING.put(DecimalMax.class, new DecimalMaxClientValidationConstraint());
        CONSTRAINT_MAPPING.put(AssertTrue.class, new AssertTrueClientValidationConstraint());
        CONSTRAINT_MAPPING.put(AssertFalse.class, new AssertFalseClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Digits.class, new DigitsClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Past.class, new PastClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Future.class, new FutureClientValidationConstraint());
        CONSTRAINT_MAPPING.put(Pattern.class, new PatternClientValidationConstraint());
    }
}

